<?php
error_reporting(0);
include 'koneksi.php';
include 'header2.php';

// **Ambil data hasil perhitungan dari tabel hasil2**
$hasil_perhitungan = query("SELECT * FROM hasil2 ORDER BY nilai DESC");

?>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-5">
            <div class="card-header bg-success text-white text-center mb-1">
                <h2 class="text-center flex-grow-1 " style="font-size: 28px; font-weight: bold;">
                <i class="fas fa-check"></i> RANKING RESULTS AND CONCLUSION</h2>
            </div>

            <br>

            <div class="card shadow-sm">
                <div class="card-body">
                    
                    <!-- **Check if calculation results are empty** -->
                    <?php if (empty($hasil_perhitungan)) : ?>
                        <div class="alert alert-danger text-center">
                            <strong>⚠️ No calculation results yet!</strong> Please perform the calculation process first on the SPK page.
                        </div>
                    <?php else : ?>

                        <!-- **Display ranking results** -->
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered text-center w-100" style="font-size: 18px;">
                                <thead class="table-success">
                                    <tr>
                                        <th style="width: 10%;">Rank</th>
                                        <th style="width: 50%;">Channel Name</th>
                                        <th style="width: 20%;">Final Score</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $rank = 1; ?>
                                    <?php foreach ($hasil_perhitungan as $row) : ?>
                                        <tr <?= ($rank == 1)?>;>
                                            <td style="font-weight: bold;"><?= $rank++; ?></td>
                                            <td><?= htmlspecialchars($row['nama']); ?></td>
                                            <td style="font-weight: bold;"><?= number_format($row['nilai'], 6, '.', ''); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                        <br><br>

                        <div class="text-center">
                            <a href="proses2.php" class="btn btn-lg btn-outline-success">
                                <i class="fas fa-calculator"></i> View Calculation Process
                            </a>
                        </div>

                        <br><br>


                <!-- **Calculation Results Conclusion** -->
                <div class="card shadow-lg">
                    <div class="card-header bg-success text-white text-center">
                        <h4><i class="fas fa-lightbulb"></i> Conclusion</h4>
                    </div>
                    <div class="card-body">
                        <?php
                        // Check if there is more than one alternative with the highest score
                        $highest_score = $hasil_perhitungan[0]['nilai'];
                        $top_alternatives = array_filter($hasil_perhitungan, function ($alt) use ($highest_score) {
                            return $alt['nilai'] == $highest_score;
                        });

                        if (count($top_alternatives) > 1) : ?>
                            <p class="text-justify" style="font-size: 18px;">
                                Based on the calculation results using the <b>Weighted Product</b> method, it was found that there are <b><?= count($top_alternatives); ?></b> channels with the same highest score.
                                This indicates that several channels have comparable quality in delivering effective learning.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Here is the list of top-ranked channels:
                            </p>

                            <ul style="font-size: 18px;">
                                <?php foreach ($top_alternatives as $alt) : ?>
                                    <li><b style="color: red;"><?= htmlspecialchars($alt['nama']); ?></b> with a final score of <b style="color: red;"><?= number_format($alt['nilai'], 6, '.', ''); ?></b></li>
                                <?php endforeach; ?>
                            </ul>

                            <p class="text-justify" style="font-size: 18px;">
                                The existence of multiple channels with the highest scores indicates that several YouTube channels meet the criteria for effective learning.
                                The factors contributing to this effectiveness include the number of views, the number of subscribers, video upload frequency, and the background of the content creator.
                                Therefore, these channels can serve as primary references in selecting learning sources for Informatics Engineering students.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Additionally, YouTube can also be utilized by lecturers as a storage medium for lecture archives or recordings of past learning sessions.
                                This provides greater flexibility in the teaching-learning process, allowing students to access materials anytime and anywhere.
                                With well-documented lecture recordings, students have the opportunity to revisit materials that they have not fully understood without time constraints.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                This flexibility makes YouTube an adaptive learning platform, enabling students to learn at their own pace and according to their preferred learning style.
                                Furthermore, lecturers can use YouTube as a medium to organize more structured learning materials, which can be used in the long term as valuable academic references.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Moreover, YouTube not only serves as a learning resource for students but also as a teaching aid for lecturers in developing more effective teaching strategies.
                                Recorded lecture materials uploaded to YouTube can act as a learning archive, allowing students to revisit delivered materials anytime based on their academic needs.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                With video-based learning documentation, lecturers can analyze the teaching methods applied and evaluate their effectiveness.
                                Thus, YouTube not only plays a role in providing broader accessibility to materials for students but also supports the continuous improvement of teaching quality in academic environments.
                            </p>


                            <?php else : ?>
                            <p class="text-justify" style="font-size: 18px;">
                                Based on the calculation results using the <b>Weighted Product</b> method, the top-ranked channel is 
                                <b style="color: red;"><?= htmlspecialchars($hasil_perhitungan[0]['nama']); ?></b>, with a final score of 
                                <b style="color: red;"><?= number_format($hasil_perhitungan[0]['nilai'], 6, '.', ''); ?></b>. 
                                This channel excels in various aspects such as the number of views, number of subscribers, and high video upload frequency, 
                                making it the best recommended learning medium for Informatics Engineering students.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                The next-ranked channels also have good quality, but there are score differences in certain criteria that affect the final results. 
                                Therefore, this ranking list can serve as a reference for selecting the most suitable YouTube channel for learning needs.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Additionally, YouTube can also be utilized by lecturers as a storage medium for lecture archives or recordings of past learning sessions.
                                This provides greater flexibility in the teaching-learning process, allowing students to access materials anytime and anywhere.
                                With well-documented lecture recordings, students have the opportunity to revisit materials they have not fully understood without time constraints.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                This flexibility makes YouTube an adaptive learning platform, enabling students to learn at their own pace and according to their preferred learning style.
                                Furthermore, lecturers can use YouTube as a medium to organize more structured learning materials, which can be used in the long term as valuable academic references.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                Moreover, YouTube not only serves as a learning resource for students but also as a teaching aid for lecturers in developing more effective teaching strategies.
                                Recorded lecture materials uploaded to YouTube can act as a learning archive, allowing students to revisit delivered materials anytime based on their academic needs.
                            </p>

                            <p class="text-justify" style="font-size: 18px;">
                                With video-based learning documentation, lecturers can analyze the teaching methods applied and evaluate their effectiveness.
                                Thus, YouTube not only plays a role in providing broader accessibility to materials for students but also supports the continuous improvement of teaching quality in academic environments.
                            </p>

                        <?php endif; ?>
                        </div>
                        </div>

                        <br>

                        <!-- **Form Export to PDF** -->
                        <div class="text-center">
                            <p style="font-size: 18px;">⬇ *Download the results in PDF format*</p>
                            <form action="reportpdf2.php" method="post">
                                <button type="submit" class="btn btn-lg btn-danger" name="submit">
                                    <i class="fas fa-file-pdf"></i> Download PDF
                                </button>
                            </form>
                        </div>

                        <?php endif; ?>
                        </div>
                        </div>
                        </div>
                        </main>
                        </div>
